package ga.core.validation;

import ga.core.individual.IIndividual;

/**
 * Interface for a rule used by the {@link RuleValidator}.
 * 
 * @param <T>
 *          The generic type of individuals.
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
public interface IValidationRule<T extends IIndividual<T>> {
  /**
   * Type of the rule. The threshold depends on the type.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public enum Type {
    MANDATORY, PROPOSED, PERFECTION
  }

  /**
   * Calculates the matching degree in [0;1] for this rule. If the given
   * individual does not match the rule, 0 will be returned.
   * 
   * @param individual
   *          The individual to test.
   * @param context
   *          The GA context.
   * @return The matching degree between 0 and 1.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public float matchingDegree(T individual, GAContext context);

  /**
   * Getter for the type of this rule.
   * 
   * @return The type.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public Type getType();
}
